package ru.yandex.direct.core.entity.strategy.type.autobudgetweekbundle

import ru.yandex.direct.currency.Currency
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.constraint.CommonConstraints
import ru.yandex.direct.validation.constraint.NumberConstraints.notGreaterThan
import ru.yandex.direct.validation.constraint.NumberConstraints.notLessThan
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder

class LimitClicksValidator(private val currency: Currency) : Validator<Long, Defect<*>> {

    override fun apply(value: Long?): ValidationResult<Long, Defect<*>> =
        ModelItemValidationBuilder.of<Long, Defect<*>>(value)
            .check(CommonConstraints.notNull())
            .check(notLessThan(currency.minAutobudgetClicksBundle.toLong()))
            .check(notGreaterThan(currency.maxAutobudgetClicksBundle))
            .result
}
