package ru.yandex.direct.core.entity.strategy.type.common

import java.time.LocalDateTime
import javax.annotation.ParametersAreNonnullByDefault
import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.model.CampaignAttributionModel
import ru.yandex.direct.core.entity.campaign.model.CampaignWithAttributionModel
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy
import ru.yandex.direct.core.entity.campaign.model.StrategyName
import ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstantsService
import ru.yandex.direct.core.entity.strategy.model.CommonStrategy
import ru.yandex.direct.core.entity.strategy.model.StrategyAttributionModel
import ru.yandex.direct.core.entity.strategy.service.converter.CampaignToStrategyConverterSupport
import ru.yandex.direct.dbutil.model.ClientId

@Component
@ParametersAreNonnullByDefault
class CampaignToCommonStrategyConverterSupport(val campaignConstantsService: CampaignConstantsService) :
    CampaignToStrategyConverterSupport<CommonStrategy> {

    override fun fillTypeSpecificFields(
        strategy: CommonStrategy,
        clientId: ClientId,
        now: LocalDateTime,
        campaign: CampaignWithPackageStrategy
    ) {
        strategy.type = toStrategyName(campaign.strategy.strategyName)
        strategy.clientId = clientId.asLong()
        strategy.isPublic = false
        strategy.walletId = campaign.walletId
        strategy.lastChange = now
        strategy.statusArchived = false
        if (campaign is CampaignWithAttributionModel) {
            strategy.attributionModel = toStrategyAttributionModel(
                campaign.attributionModel ?: campaignConstantsService.defaultAttributionModel
            )
        } else {
            strategy.attributionModel = toStrategyAttributionModel(campaignConstantsService.defaultAttributionModel)
        }
        strategy.cids = listOf(campaign.id)
    }

    override fun getTypeClass() = CommonStrategy::class.java

    companion object {
        private fun toStrategyAttributionModel(attributionModel: CampaignAttributionModel): StrategyAttributionModel {
            return StrategyAttributionModel.valueOf(attributionModel.name)
        }

        fun toStrategyName(type: StrategyName): ru.yandex.direct.core.entity.strategy.model.StrategyName {
            return ru.yandex.direct.core.entity.strategy.model.StrategyName.valueOf(type.name)
        }
    }
}
