package ru.yandex.direct.core.entity.strategy.type.common;

import java.time.LocalDateTime;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.strategy.container.StrategyUpdateOperationContainer;
import ru.yandex.direct.core.entity.strategy.model.CommonStrategy;
import ru.yandex.direct.core.entity.strategy.service.CampaignUpdateHelper;
import ru.yandex.direct.core.entity.strategy.service.update.AbstractStrategyUpdateOperationTypeSupport;
import ru.yandex.direct.model.AppliedChanges;

@Component
@ParametersAreNonnullByDefault
public class CommonStrategyUpdateTypeSupport extends AbstractStrategyUpdateOperationTypeSupport<CommonStrategy> {
    private final CampaignUpdateHelper campaignUpdateHelper;

    @Autowired
    public CommonStrategyUpdateTypeSupport(CampaignUpdateHelper campaignUpdateHelper) {
        this.campaignUpdateHelper = campaignUpdateHelper;
    }

    @Override
    public void onChangesApplied(StrategyUpdateOperationContainer container,
                                 List<AppliedChanges<CommonStrategy>> appliedChanges) {
        LocalDateTime timeNow = container.getNow();
        appliedChanges.forEach(changes -> {
            if (changes.hasActuallyChangedProps()) {
                changes.modify(CommonStrategy.LAST_CHANGE, timeNow);
            }
        });
    }

    @Override
    public void updateRelatedEntitiesInTransaction(DSLContext dslContext,
                                                   StrategyUpdateOperationContainer updateContainer,
                                                   List<AppliedChanges<CommonStrategy>> appliedChanges) {
        campaignUpdateHelper.updateCampaignsInTransaction(updateContainer, dslContext, appliedChanges);
    }

    @Override
    public Class<CommonStrategy> getTypeClass() {
        return CommonStrategy.class;
    }
}
