package ru.yandex.direct.core.entity.strategy.type.common

import ru.yandex.direct.core.entity.campaign.service.validation.StrategyDefects
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.builder.When
import ru.yandex.direct.validation.constraint.CommonConstraints.notTrue
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.validation.util.validateObject

class IsPublicPreValidator(private val hasWallet: Boolean) : Validator<Boolean?, Defect<*>> {
    override fun apply(t: Boolean?): ValidationResult<Boolean?, Defect<*>> =
        validateObject(t) {
            check(
                notTrue(),
                StrategyDefects.publicStrategyNotSupportedForClientsWithoutWallet(),
                When.isFalse(hasWallet)
            )
        }
}
