package ru.yandex.direct.core.entity.strategy.type.common

import ru.yandex.direct.core.entity.campaign.service.validation.StrategyDefects
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.builder.When
import ru.yandex.direct.validation.constraint.CommonConstraints.isTrue
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.validation.util.validateObject

class IsPublicValidator(
    private val campaigns: List<Long>?,
    private val currentIsPublicValue: Boolean? = null,
) : Validator<Boolean?, Defect<*>> {
    override fun apply(t: Boolean?): ValidationResult<Boolean?, Defect<*>> =
        validateObject(t) {
            check(
                isTrue(),
                StrategyDefects.changePublicStrategyToPrivate(),
                When.isTrue(currentIsPublicValue == true)
            )
            check(
                isTrue(),
                StrategyDefects.linkingNonPublicStrategyToSeveralCampaigns(),
                When.isTrue((campaigns?.size ?: 0) > 1)
            )
        }
}
