package ru.yandex.direct.core.entity.strategy.type.common

import ru.yandex.direct.validation.builder.Constraint
import ru.yandex.direct.validation.builder.ListValidationBuilder
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.defect.CommonDefects
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult

class LinkedCampaignIdsBeforeApplyValidator(
    private val oldCampaignIds: List<Long>
) :
    Validator<List<Long>?, Defect<*>> {
    override fun apply(t: List<Long>?): ValidationResult<List<Long>?, Defect<*>> {
        val vb = ListValidationBuilder.of<Long, Defect<*>>(t)

        return vb.check(campaignIdsNotDeleted()).result
    }

    /**
     * Кампании не удалялись
     */
    private fun <C : Collection<Long?>?> campaignIdsNotDeleted(): Constraint<C, Defect<*>> {
        return Constraint.fromPredicate(
            { campaignIds ->
                campaignIds?.containsAll(oldCampaignIds) == true
            },
            CommonDefects.invalidValue()
        )
    }
}
