package ru.yandex.direct.core.entity.strategy.type.common

import ru.yandex.direct.core.entity.campaign.model.CommonCampaign
import ru.yandex.direct.validation.builder.ListValidationBuilder
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.constraint.CommonConstraints
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult

class LinkedCampaignIdsPreValidator (
    private val campaigns: List<CommonCampaign>
): Validator<List<Long>?, Defect<*>> {
    override fun apply(t: List<Long>?): ValidationResult<List<Long>?, Defect<*>> {

        val vb = ListValidationBuilder.of<Long, Defect<*>>(t)
        val campaignIds = campaigns.map { it.id }.toSet()
        vb.checkEach(CommonConstraints.inSet(campaignIds))

        return vb.result
    }
}
