package ru.yandex.direct.core.entity.strategy.type.common

import ru.yandex.direct.core.entity.campaign.model.CommonCampaign
import ru.yandex.direct.core.entity.campaign.service.validation.StrategyDefects
import ru.yandex.direct.core.entity.strategy.model.CommonStrategy
import ru.yandex.direct.core.entity.strategy.utils.StrategyModelUtils.campaignIds
import ru.yandex.direct.validation.builder.Constraint
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.validation.util.validateObject

class LinkedCampaignTypesValidator(private val currentCampaigns: List<CommonCampaign>) :
    Validator<CommonStrategy, Defect<*>> {

    override fun apply(t: CommonStrategy): ValidationResult<CommonStrategy, Defect<*>> =
        validateObject(t) {
            check(
                Constraint.fromPredicate(
                    { strategy ->
                        val campaignTypeById = currentCampaigns
                            .associate { it.id to it.type }
                            .toMap()

                        strategy.campaignIds()
                            .mapNotNull { campaignTypeById[it] }
                            .distinct()
                            .count() <= 1
                    },
                    StrategyDefects.campaignsWithDifferentTypesInOnePackage()
                )
            )
        }
}
