package ru.yandex.direct.core.entity.strategy.type.common

import ru.yandex.direct.core.entity.strategy.service.StrategyConstants.MAX_NAME_LENGTH
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.builder.When
import ru.yandex.direct.validation.constraint.StringConstraints.maxStringLength
import ru.yandex.direct.validation.constraint.StringConstraints.notBlank
import ru.yandex.direct.validation.constraint.StringConstraints.onlyUtf8Mb3Symbols
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.validation.util.validateObject

object NameValidator : Validator<String?, Defect<*>> {
    override fun apply(t: String?): ValidationResult<String?, Defect<*>> =
        validateObject(t) {
            check(notBlank(), When.isValid())
            check(onlyUtf8Mb3Symbols(), When.isValid())
            check(maxStringLength(MAX_NAME_LENGTH));
        }
}
