package ru.yandex.direct.core.entity.strategy.type.common

import ru.yandex.direct.core.entity.campaign.service.validation.StrategyDefects
import ru.yandex.direct.validation.builder.Constraint
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.validation.util.validateObject

class NumberOfCidsValidator (private val maxNumberOfCids: Int) : Validator<List<Long>?, Defect<*>> {
    override fun apply(t: List<Long>?): ValidationResult<List<Long>?, Defect<*>> =
        validateObject(t) {
            check(Constraint.fromPredicate(
                {
                    (t == null) || (t.size <= maxNumberOfCids)
                },
                StrategyDefects.tooMuchCampaignsLinkedToStrategy(maxNumberOfCids))
            )
    }
}
