package ru.yandex.direct.core.entity.strategy.type.common

import ru.yandex.direct.core.entity.campaign.service.validation.StrategyDefects.unavailableStrategyTypeForPublication
import ru.yandex.direct.core.entity.strategy.model.CommonStrategy
import ru.yandex.direct.core.entity.strategy.service.StrategyConstants
import ru.yandex.direct.validation.builder.Constraint
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.validation.util.validateObject

class PublicStrategyTypeValidator : Validator<CommonStrategy, Defect<*>> {
    override fun apply(t: CommonStrategy): ValidationResult<CommonStrategy, Defect<*>> =
        validateObject(t) {
            check(
                Constraint.fromPredicate(
                    { strategy -> StrategyConstants.AVAILABLE_STRATEGY_TYPES_FOR_PUBLIC_STRATEGY.contains(strategy.type) },
                    unavailableStrategyTypeForPublication()
                )
            )
        }
}
