package ru.yandex.direct.core.entity.strategy.type.common

import ru.yandex.direct.core.entity.campaign.service.validation.StrategyDefects
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.constraint.CommonConstraints
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.validation.util.validateObject

object StatusArchivedUpdateValidator : Validator<Boolean?, Defect<*>> {
    override fun apply(t: Boolean?): ValidationResult<Boolean?, Defect<*>> =
        validateObject(t) {
            check(
                CommonConstraints.notTrue(),
                StrategyDefects.archivedStrategyModification()
            )
        }
}
