package ru.yandex.direct.core.entity.strategy.type.common

import ru.yandex.direct.core.entity.strategy.model.CommonStrategy
import ru.yandex.direct.core.entity.strategy.model.StrategyName
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.constraint.CommonConstraints
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.validation.util.validateObject

class TypeValidator(val commonStrategy: CommonStrategy) : Validator<StrategyName?, Defect<*>> {

    override fun apply(t: StrategyName?): ValidationResult<StrategyName?, Defect<*>> =
        validateObject(t) {
            check(CommonConstraints.notNull())
        }
}
