package ru.yandex.direct.core.entity.strategy.type.common

import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.builder.When
import ru.yandex.direct.validation.constraint.CommonConstraints
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.validation.util.validateObject

class WalletIdValidator(private val isCampaignMigration: Boolean = false) : Validator<Long?, Defect<*>> {
    override fun apply(t: Long?): ValidationResult<Long?, Defect<*>> =
        validateObject(t) {
            check(CommonConstraints.isNull(), When.isFalse(isCampaignMigration))
            check(CommonConstraints.notNull(), When.isTrue(isCampaignMigration))
        }
}
