package ru.yandex.direct.core.entity.strategy.type.defaultmanualstrategy

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy
import ru.yandex.direct.core.entity.strategy.model.DefaultManualStrategy
import ru.yandex.direct.core.entity.strategy.service.converter.CampaignToStrategyConverterSupport
import ru.yandex.direct.dbutil.model.ClientId
import java.time.LocalDateTime
import javax.annotation.ParametersAreNonnullByDefault

@Component
@ParametersAreNonnullByDefault
class CampaignToDefaultManualStrategyConverterSupport : CampaignToStrategyConverterSupport<DefaultManualStrategy> {
    override fun fillTypeSpecificFields(
        strategy: DefaultManualStrategy,
        clientId: ClientId,
        now: LocalDateTime,
        campaign: CampaignWithPackageStrategy
    ) {
        strategy.withEnableCpcHold(campaign.enableCpcHold)
    }

    override fun getTypeClass() = DefaultManualStrategy::class.java
}
