package ru.yandex.direct.core.entity.strategy.type.defaultmanualstrategy

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.strategy.container.StrategyAddOperationContainer
import ru.yandex.direct.core.entity.strategy.model.DefaultManualStrategy
import ru.yandex.direct.core.entity.strategy.service.add.AbstractStrategyAddOperationTypeSupport
import ru.yandex.direct.core.entity.strategy.type.defaultmanualstrategy.EnableCpcHoldPreValidator.Companion.isCampaignTypeForbidden

@Component
class DefaultManualStrategyAddTypeSupport : AbstractStrategyAddOperationTypeSupport<DefaultManualStrategy>() {
    override fun getTypeClass(): Class<DefaultManualStrategy> = DefaultManualStrategy::class.java

    override fun onPreValidated(addContainer: StrategyAddOperationContainer,
                                models: List<DefaultManualStrategy>) {
        // from CampaignWithEnableCpcHoldForbiddenAddOperationSupport
        models.forEach {
            if (isCampaignTypeForbidden(addContainer.campaignType(it))) {
                it.enableCpcHold = false
            }
        }
    }
}
