package ru.yandex.direct.core.entity.strategy.type.defaultmanualstrategy

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.strategy.container.StrategyAddOperationContainer
import ru.yandex.direct.core.entity.strategy.model.DefaultManualStrategy
import ru.yandex.direct.core.entity.strategy.validation.add.AbstractStrategyAddValidationTypeSupport
import ru.yandex.direct.validation.builder.ListValidationBuilder
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult

@Component
class DefaultManualStrategyAddValidationTypeSupport : AbstractStrategyAddValidationTypeSupport<DefaultManualStrategy>() {
    override fun getTypeClass(): Class<DefaultManualStrategy> = DefaultManualStrategy::class.java

    override fun preValidate(container: StrategyAddOperationContainer,
                             vr: ValidationResult<List<DefaultManualStrategy>, Defect<*>>): ValidationResult<List<DefaultManualStrategy>, Defect<*>> {
        val validator = DefaultManualStrategyValidatorProvider.createAddStrategyPreValidator(container)
        
        return ListValidationBuilder(vr)
            .checkEachBy(validator)
            .result
    }

    override fun validate(container: StrategyAddOperationContainer,
                          vr: ValidationResult<List<DefaultManualStrategy>, Defect<*>>): ValidationResult<List<DefaultManualStrategy>, Defect<*>> {
        val validator = DefaultManualStrategyValidatorProvider.createAddStrategyValidator(container)

        return ListValidationBuilder(vr)
            .checkEachBy(validator)
            .result
    }
}
