package ru.yandex.direct.core.entity.strategy.type.defaultmanualstrategy;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.TableField;
import org.springframework.stereotype.Component;

import ru.yandex.direct.common.util.RepositoryUtils;
import ru.yandex.direct.core.entity.strategy.model.DefaultManualStrategy;
import ru.yandex.direct.core.entity.strategy.repository.BaseStrategyDataFieldRepositoryTypeSupport;
import ru.yandex.direct.dbschema.ppc.enums.StrategiesEnableCpcHold;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;

import static ru.yandex.direct.common.util.RepositoryUtils.booleanToYesNoWithDefault;
import static ru.yandex.direct.dbschema.ppc.tables.Strategies.STRATEGIES;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;

@Component
@ParametersAreNonnullByDefault
public class DefaultManualStrategyRepositoryTypeSupport
        extends BaseStrategyDataFieldRepositoryTypeSupport<DefaultManualStrategy> {
    protected DefaultManualStrategyRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public JooqMapper<DefaultManualStrategy> createMapper() {
        return baseBuilder()
                .map(convertibleProperty(
                        DefaultManualStrategy.ENABLE_CPC_HOLD,
                        STRATEGIES.ENABLE_CPC_HOLD,
                        RepositoryUtils::booleanFromYesNo,
                        value -> booleanToYesNoWithDefault(
                                value, StrategiesEnableCpcHold.class, StrategiesEnableCpcHold.No
                        )
                ))
                .build();
    }

    @Override
    public Set<TableField<?, Long>> getPrimaryKeys() {
        return Set.of(STRATEGIES.STRATEGY_ID);
    }

    @Override
    public Class<DefaultManualStrategy> getTypeClass() {
        return DefaultManualStrategy.class;
    }
}
