package ru.yandex.direct.core.entity.strategy.type.defaultmanualstrategy

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.model.CampaignWithEnableCpcHoldForbidden
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy
import ru.yandex.direct.core.entity.strategy.model.DefaultManualStrategy
import ru.yandex.direct.core.entity.strategy.service.converter.StrategyToCampaignConverterSupport
import ru.yandex.direct.model.ModelChanges
import java.time.LocalDateTime
import javax.annotation.ParametersAreNonnullByDefault

@Component
@ParametersAreNonnullByDefault
class DefaultManualStrategyToCampaignConverterSupport : StrategyToCampaignConverterSupport<DefaultManualStrategy> {
    override fun fillCampaignTypeSpecificFields(
        strategy: DefaultManualStrategy,
        now: LocalDateTime,
        campaign: CampaignWithPackageStrategy
    ) {
        if (!CampaignWithEnableCpcHoldForbidden::class.java.isAssignableFrom(campaign.javaClass)) {
            campaign.enableCpcHold = strategy.enableCpcHold
        }
    }

    override fun processCampaignModelChangesTypeSpecificProperties(
        strategy: DefaultManualStrategy,
        now: LocalDateTime,
        modelChanges: ModelChanges<CampaignWithPackageStrategy>,
        campaignClass: Class<out CampaignWithPackageStrategy>
    ) {
        if (!CampaignWithEnableCpcHoldForbidden::class.java.isAssignableFrom(modelChanges.modelType)) {
            modelChanges.process(strategy.enableCpcHold, CampaignWithPackageStrategy.ENABLE_CPC_HOLD)
        }
    }

    override fun getTypeClass() = DefaultManualStrategy::class.java
}
