package ru.yandex.direct.core.entity.strategy.type.defaultmanualstrategy

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.strategy.container.StrategyUpdateOperationContainer
import ru.yandex.direct.core.entity.strategy.model.DefaultManualStrategy
import ru.yandex.direct.core.entity.strategy.validation.update.AbstractStrategyUpdateValidationTypeSupport
import ru.yandex.direct.model.ModelChanges
import ru.yandex.direct.validation.builder.ListValidationBuilder
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult

@Component
class DefaultManualStrategyUpdateValidationTypeSupport : AbstractStrategyUpdateValidationTypeSupport<DefaultManualStrategy>() {
    override fun getTypeClass(): Class<DefaultManualStrategy> = DefaultManualStrategy::class.java

    override fun validate(container: StrategyUpdateOperationContainer,
                          vr: ValidationResult<List<DefaultManualStrategy>, Defect<*>>): ValidationResult<List<DefaultManualStrategy>, Defect<*>> {
        val validator = DefaultManualStrategyValidatorProvider.createUpdateStrategyValidator(container)

        return ListValidationBuilder(vr)
            .checkEachBy(validator)
            .result
    }

    override fun preValidate(container: StrategyUpdateOperationContainer,
                             vr: ValidationResult<List<ModelChanges<DefaultManualStrategy>>, Defect<*>>): ValidationResult<List<ModelChanges<DefaultManualStrategy>>, Defect<*>> {
        val preValidator = DefaultManualStrategyValidatorProvider.createUpdateStrategyPreValidator(container)

        return ListValidationBuilder(vr)
            .checkEachBy(preValidator)
            .result
    }
}
