package ru.yandex.direct.core.entity.strategy.type.defaultmanualstrategy

import ru.yandex.direct.core.entity.strategy.container.AbstractStrategyOperationContainer
import ru.yandex.direct.core.entity.strategy.container.StrategyAddOperationContainer
import ru.yandex.direct.core.entity.strategy.container.StrategyUpdateOperationContainer
import ru.yandex.direct.core.entity.strategy.model.DefaultManualStrategy
import ru.yandex.direct.core.entity.strategy.validation.AbstractStrategyValidatorProvider
import ru.yandex.direct.model.ModelChanges
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.wrapper.ModelChangesValidationBuilder
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder

object DefaultManualStrategyValidatorProvider : AbstractStrategyValidatorProvider<DefaultManualStrategy>() {
    override fun createStrategyValidator(container: AbstractStrategyOperationContainer): Validator<DefaultManualStrategy, Defect<*>> =
        Validator { strategy: DefaultManualStrategy ->
            val campaignType = container.campaignType(strategy)

            val vb = ModelItemValidationBuilder.of(strategy)

            vb.item(DefaultManualStrategy.ENABLE_CPC_HOLD)
                .checkBy(EnableCpcHoldValidator(campaignType))

            vb.result
        }

    override fun createAddStrategyPreValidator(container: StrategyAddOperationContainer): Validator<DefaultManualStrategy, Defect<*>> =
        Validator { strategy: DefaultManualStrategy ->
            val campaignType = container.campaignType(strategy)
            val vb = ModelItemValidationBuilder.of(strategy)

            vb.item(DefaultManualStrategy.ENABLE_CPC_HOLD)
                .checkBy(EnableCpcHoldPreValidator(campaignType, container.options.isCopy))

            vb.result
        }

    override fun createUpdateStrategyPreValidator(container: StrategyUpdateOperationContainer): Validator<ModelChanges<DefaultManualStrategy>, Defect<*>> =
        Validator { changes: ModelChanges<DefaultManualStrategy> ->
            val vr = ModelChangesValidationBuilder.of(changes)

            vr.item(DefaultManualStrategy.ENABLE_CPC_HOLD)
                .checkBy(EnableCpcHoldChangesPreValidator(container.campaignTypeById(changes.id)))

            vr.result
        }
}
