package ru.yandex.direct.core.entity.strategy.type.defaultmanualstrategy

import ru.yandex.direct.core.entity.campaign.model.CampaignType
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.builder.When
import ru.yandex.direct.validation.constraint.CommonConstraints.isNull
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.validation.util.validateObject

class EnableCpcHoldPreValidator(private val campaignType: CampaignType?,
                                private val isCopy: Boolean = false) : Validator<Boolean?, Defect<*>> {
    override fun apply(t: Boolean?): ValidationResult<Boolean?, Defect<*>> =
        validateObject(t) {
            check(isNull(), When.isTrue(!isCopy && isCampaignTypeForbidden(campaignType)))
        }

    companion object {
        fun isCampaignTypeForbidden(campaignType: CampaignType?) = FORBIDDEN_FOR_CAMPAIGN_TYPES.contains(campaignType)

        private val FORBIDDEN_FOR_CAMPAIGN_TYPES = setOf(
            CampaignType.CONTENT_PROMOTION,
            CampaignType.CPM_BANNER,
            CampaignType.CPM_PRICE,
            CampaignType.CPM_YNDX_FRONTPAGE,
            CampaignType.INTERNAL_AUTOBUDGET,
            CampaignType.INTERNAL_DISTRIB,
            CampaignType.INTERNAL_FREE
        )
    }
}
