package ru.yandex.direct.core.entity.strategy.type.defaultmanualstrategy

import ru.yandex.direct.core.entity.campaign.model.CampaignType
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.builder.When
import ru.yandex.direct.validation.constraint.CommonConstraints.isNull
import ru.yandex.direct.validation.constraint.CommonConstraints.notNull
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.validation.util.validateObject

class EnableCpcHoldValidator(val campaignType: CampaignType?) : Validator<Boolean?, Defect<*>> {
    override fun apply(t: Boolean?): ValidationResult<Boolean?, Defect<*>> =
        validateObject(t) {
            check(notNull(), When.isTrue(isCampaignTypeSupportsEnableCpc(campaignType)))
        }

    companion object {
        fun isCampaignTypeSupportsEnableCpc(campaignType: CampaignType?) = CAMPAIGN_TYPES_WITH_ENABLE_CPC_SUPPORT.contains(campaignType)

        private val CAMPAIGN_TYPES_WITH_ENABLE_CPC_SUPPORT = setOf(
            CampaignType.MCBANNER,
            CampaignType.MOBILE_CONTENT,
            CampaignType.TEXT,
            CampaignType.PERFORMANCE
        )
    }
}
