package ru.yandex.direct.core.entity.strategy.type.withavgbid

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy
import ru.yandex.direct.core.entity.strategy.model.StrategyWithAvgBid
import ru.yandex.direct.core.entity.strategy.service.converter.CampaignToStrategyConverterSupport
import ru.yandex.direct.dbutil.model.ClientId
import java.time.LocalDateTime
import javax.annotation.ParametersAreNonnullByDefault

@Component
@ParametersAreNonnullByDefault
class CampaignToStrategyWithAvgBidConverterSupport : CampaignToStrategyConverterSupport<StrategyWithAvgBid> {
    override fun fillTypeSpecificFields(
        strategy: StrategyWithAvgBid,
        clientId: ClientId,
        now: LocalDateTime,
        campaign: CampaignWithPackageStrategy
    ) {
        strategy.withAvgBid(campaign.strategy.strategyData.avgBid)
    }

    override fun getTypeClass() = StrategyWithAvgBid::class.java
}
