package ru.yandex.direct.core.entity.strategy.type.withavgbid

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.strategy.container.StrategyAddOperationContainer
import ru.yandex.direct.core.entity.strategy.model.StrategyWithAvgBid
import ru.yandex.direct.core.entity.strategy.validation.add.AbstractStrategyAddValidationTypeSupport
import ru.yandex.direct.validation.builder.ListValidationBuilder
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult

@Component
class StrategyWithAvgBidAddValidationTypeSupport() : AbstractStrategyAddValidationTypeSupport<StrategyWithAvgBid>() {

    override fun validate(
        container: StrategyAddOperationContainer,
        vr: ValidationResult<List<StrategyWithAvgBid>, Defect<*>>
    ): ValidationResult<List<StrategyWithAvgBid>, Defect<*>> =
        ListValidationBuilder(vr)
            .checkEachBy(StrategyWithAvgBidValidatorProvider.createAddStrategyValidator(container))
            .result

    override fun getTypeClass(): Class<StrategyWithAvgBid> = StrategyWithAvgBid::class.java
}
