package ru.yandex.direct.core.entity.strategy.type.withavgbid;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.TableField;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.strategy.model.StrategyWithAvgBid;
import ru.yandex.direct.core.entity.strategy.repository.BaseStrategyDataFieldRepositoryTypeSupport;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;

import static ru.yandex.direct.dbschema.ppc.tables.Strategies.STRATEGIES;
import static ru.yandex.direct.jooqmapper.JsonReaderWriterBuilders.jsonBigDecimal;

@Component
@ParametersAreNonnullByDefault
public class StrategyWithAvgBidTypeRepositorySupport
        extends BaseStrategyDataFieldRepositoryTypeSupport<StrategyWithAvgBid> {

    protected StrategyWithAvgBidTypeRepositorySupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public JooqMapper<StrategyWithAvgBid> createMapper() {
        return baseBuilder()
                .map(jsonBigDecimal(StrategyWithAvgBid.AVG_BID, STRATEGIES.STRATEGY_DATA, "avg_bid"))
                .build();
    }

    @Override
    public Set<TableField<?, Long>> getPrimaryKeys() {
        return Set.of(STRATEGIES.STRATEGY_ID);
    }

    @Override
    public Class<StrategyWithAvgBid> getTypeClass() {
        return StrategyWithAvgBid.class;
    }
}
