package ru.yandex.direct.core.entity.strategy.type.withavgbid

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.strategy.container.StrategyUpdateOperationContainer
import ru.yandex.direct.core.entity.strategy.model.StrategyWithAvgBid
import ru.yandex.direct.core.entity.strategy.validation.update.AbstractStrategyUpdateValidationTypeSupport
import ru.yandex.direct.validation.builder.ListValidationBuilder
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult

@Component
class StrategyWithAvgBidUpdateValidationTypeSupport :
    AbstractStrategyUpdateValidationTypeSupport<StrategyWithAvgBid>() {

    override fun validate(
        container: StrategyUpdateOperationContainer,
        vr: ValidationResult<MutableList<StrategyWithAvgBid>, Defect<*>>
    ): ValidationResult<List<StrategyWithAvgBid>, Defect<*>> {
        val validator = StrategyWithAvgBidValidatorProvider.createUpdateStrategyValidator(container)

        return ListValidationBuilder(vr)
            .checkEachBy(validator)
            .result
    }

    override fun getTypeClass(): Class<StrategyWithAvgBid> = StrategyWithAvgBid::class.java
}
