package ru.yandex.direct.core.entity.strategy.type.withavgbid

import ru.yandex.direct.core.entity.strategy.container.AbstractStrategyOperationContainer
import ru.yandex.direct.core.entity.strategy.model.StrategyName
import ru.yandex.direct.core.entity.strategy.model.StrategyWithAvgBid
import ru.yandex.direct.core.entity.strategy.model.StrategyWithBid
import ru.yandex.direct.core.entity.strategy.model.StrategyWithWeeklyBudget
import ru.yandex.direct.core.entity.strategy.validation.AbstractStrategyValidatorProvider
import ru.yandex.direct.core.entity.strategy.validation.validators.AvgBidValidator
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.builder.When
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder

object StrategyWithAvgBidValidatorProvider : AbstractStrategyValidatorProvider<StrategyWithAvgBid>() {

    override fun createStrategyValidator(container: AbstractStrategyOperationContainer) =
        Validator { strategy: StrategyWithAvgBid ->
            val sum = when (strategy) {
                is StrategyWithWeeklyBudget -> strategy.sum
                else -> null
            }
            val bid = when (strategy) {
                is StrategyWithBid -> strategy.bid
                else -> null
            }

            val vb = ModelItemValidationBuilder.of(strategy)

            vb.item(StrategyWithAvgBid.AVG_BID)
                .checkBy(AvgBidValidator(container.currency, sum, bid, container.campaignType(strategy), strategy.type),
                    When.isTrue(strategy.avgBid != null || StrategyName.AUTOBUDGET_WEEK_BUNDLE != strategy.type)
                )

            vb.result
        }
}
