package ru.yandex.direct.core.entity.strategy.type.withavgcpa

import ru.yandex.direct.core.entity.campaign.model.CampaignType
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.strategy.CommonStrategyValidatorConstants
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.strategy.StrategyValidatorConstantsBuilder
import ru.yandex.direct.currency.Currency
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.constraint.CommonConstraints.notNull
import ru.yandex.direct.validation.constraint.NumberConstraints.notLessThan
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.validation.util.validateObject
import java.math.BigDecimal

class AvgCpaValidator(private val container: ValidationContainer) : Validator<BigDecimal, Defect<*>> {

    override fun apply(t: BigDecimal?): ValidationResult<BigDecimal?, Defect<*>> =
        validateObject(t) {
            check(notNull())
            check(notLessThan(container.constants.minAvgCpa))
        }

    companion object {
        data class ValidationContainer(val currency: Currency,
                                       val campaignType: CampaignType?) {
            val constants =
                campaignType?.let {
                    StrategyValidatorConstantsBuilder.build(it, currency)
                } ?: CommonStrategyValidatorConstants(currency)
        }
    }

}

