package ru.yandex.direct.core.entity.strategy.type.withavgcpa

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy
import ru.yandex.direct.core.entity.strategy.model.StrategyWithAvgCpa
import ru.yandex.direct.core.entity.strategy.service.converter.CampaignToStrategyConverterSupport
import ru.yandex.direct.dbutil.model.ClientId
import java.time.LocalDateTime
import javax.annotation.ParametersAreNonnullByDefault

@Component
@ParametersAreNonnullByDefault
class CampaignToStrategyWithAvgCpaConverterSupport : CampaignToStrategyConverterSupport<StrategyWithAvgCpa> {
    override fun fillTypeSpecificFields(
        strategy: StrategyWithAvgCpa,
        clientId: ClientId,
        now: LocalDateTime,
        campaign: CampaignWithPackageStrategy
    ) {
        strategy.withAvgCpa(campaign.strategy.strategyData.avgCpa)
    }

    override fun getTypeClass() = StrategyWithAvgCpa::class.java
}
