package ru.yandex.direct.core.entity.strategy.type.withavgcpa

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.strategy.container.StrategyAddOperationContainer
import ru.yandex.direct.core.entity.strategy.model.StrategyWithAvgCpa
import ru.yandex.direct.core.entity.strategy.validation.add.AbstractStrategyAddValidationTypeSupport
import ru.yandex.direct.validation.builder.ListValidationBuilder
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult

@Component
class StrategyWithAvgCpaAddValidationTypeSupport : AbstractStrategyAddValidationTypeSupport<StrategyWithAvgCpa>() {

    override fun validate(container: StrategyAddOperationContainer, vr: ValidationResult<List<StrategyWithAvgCpa>, Defect<*>>): ValidationResult<List<StrategyWithAvgCpa>, Defect<*>> {
        val validator = StrategyWithAvgCpaValidatorProvider.createAddStrategyValidator(container)
        return ListValidationBuilder(vr)
            .checkEachBy(validator)
            .result
    }

    override fun getTypeClass(): Class<StrategyWithAvgCpa> = StrategyWithAvgCpa::class.java
}
