package ru.yandex.direct.core.entity.strategy.type.withavgcpa;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.TableField;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.strategy.model.StrategyWithAvgCpa;
import ru.yandex.direct.core.entity.strategy.repository.BaseStrategyDataFieldRepositoryTypeSupport;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;

import static ru.yandex.direct.dbschema.ppc.tables.Strategies.STRATEGIES;
import static ru.yandex.direct.jooqmapper.JsonReaderWriterBuilders.jsonBigDecimal;

@Component
@ParametersAreNonnullByDefault
public class StrategyWithAvgCpaRepositoryTypeSupport extends BaseStrategyDataFieldRepositoryTypeSupport<StrategyWithAvgCpa> {

    protected StrategyWithAvgCpaRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public JooqMapper<StrategyWithAvgCpa> createMapper() {
        return baseBuilder()
                .map(jsonBigDecimal(
                        StrategyWithAvgCpa.AVG_CPA,
                        STRATEGIES.STRATEGY_DATA,
                        "avg_cpa"
                )).build();
    }

    @Override
    public Class<StrategyWithAvgCpa> getTypeClass() {
        return StrategyWithAvgCpa.class;
    }

    @Override
    public Set<TableField<?, Long>> getPrimaryKeys() {
        return Set.of(STRATEGIES.STRATEGY_ID);
    }
}
