package ru.yandex.direct.core.entity.strategy.type.withavgcpa

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy
import ru.yandex.direct.core.entity.campaign.model.StrategyData
import ru.yandex.direct.core.entity.strategy.model.StrategyWithAvgCpa
import ru.yandex.direct.core.entity.strategy.service.converter.StrategyToCampaignConverterSupport
import ru.yandex.direct.core.entity.strategy.service.converter.StrategyToCampaignConverterUtils
import ru.yandex.direct.model.ModelChanges
import java.time.LocalDateTime
import javax.annotation.ParametersAreNonnullByDefault

@Component
@ParametersAreNonnullByDefault
class StrategyWithAvgCpaToCampaignConverterSupport : StrategyToCampaignConverterSupport<StrategyWithAvgCpa> {
    override fun fillCampaignTypeSpecificFields(
        strategy: StrategyWithAvgCpa,
        now: LocalDateTime,
        campaign: CampaignWithPackageStrategy
    ) {
        fill(StrategyToCampaignConverterUtils.createStrategyDataIfNull(campaign), strategy)
    }

    override fun processCampaignModelChangesTypeSpecificProperties(
        strategy: StrategyWithAvgCpa,
        now: LocalDateTime,
        modelChanges: ModelChanges<CampaignWithPackageStrategy>,
        campaignClass: Class<out CampaignWithPackageStrategy>
    ) {
        fill(StrategyToCampaignConverterUtils.createStrategyDataIfNull(modelChanges), strategy)
    }

    override fun getTypeClass() = StrategyWithAvgCpa::class.java

    private fun fill(strategyData: StrategyData, strategy: StrategyWithAvgCpa) {
        strategyData.avgCpa = strategy.avgCpa
    }
}
