package ru.yandex.direct.core.entity.strategy.type.withavgcpa

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.strategy.container.StrategyUpdateOperationContainer
import ru.yandex.direct.core.entity.strategy.model.StrategyWithAvgCpa
import ru.yandex.direct.core.entity.strategy.validation.update.AbstractStrategyUpdateValidationTypeSupport
import ru.yandex.direct.validation.builder.ListValidationBuilder
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult

@Component
class StrategyWithAvgCpaUpdateValidationTypeSupport : AbstractStrategyUpdateValidationTypeSupport<StrategyWithAvgCpa>() {

    override fun validate(container: StrategyUpdateOperationContainer,
                          vr: ValidationResult<List<StrategyWithAvgCpa>, Defect<*>>): ValidationResult<List<StrategyWithAvgCpa>, Defect<*>> {
        val validator = StrategyWithAvgCpaValidatorProvider.createUpdateStrategyValidator(container)
        return ListValidationBuilder(vr)
            .checkEachBy(validator)
            .result
    }

    override fun getTypeClass(): Class<StrategyWithAvgCpa> = StrategyWithAvgCpa::class.java
}
