package ru.yandex.direct.core.entity.strategy.type.withavgcpa

import ru.yandex.direct.core.entity.strategy.container.AbstractStrategyOperationContainer
import ru.yandex.direct.core.entity.strategy.model.StrategyWithAvgCpa
import ru.yandex.direct.core.entity.strategy.validation.AbstractStrategyValidatorProvider
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder

object StrategyWithAvgCpaValidatorProvider : AbstractStrategyValidatorProvider<StrategyWithAvgCpa>() {
    override fun createStrategyValidator(container: AbstractStrategyOperationContainer): Validator<StrategyWithAvgCpa, Defect<*>> =
        Validator { strategyWithAvgCpa: StrategyWithAvgCpa ->
            val validator = buildValidator(container, strategyWithAvgCpa)
            val vb = ModelItemValidationBuilder.of(strategyWithAvgCpa)

            vb.item(StrategyWithAvgCpa.AVG_CPA)
                .checkBy(validator)

            vb.result
        }

    private fun buildValidator(container: AbstractStrategyOperationContainer, strategyWithAvgCpa: StrategyWithAvgCpa): AvgCpaValidator {
        val validationContainer = AvgCpaValidator.Companion.ValidationContainer(
            container.currency,
            container.campaignType(strategyWithAvgCpa),
        )
        return AvgCpaValidator(validationContainer)
    }
}
