package ru.yandex.direct.core.entity.strategy.type.withavgcpaandpayforconversion

import ru.yandex.direct.core.entity.campaign.service.validation.CampaignWithStrategyValidationUtils
import ru.yandex.direct.currency.Currency
import ru.yandex.direct.feature.FeatureName
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.builder.When
import ru.yandex.direct.validation.constraint.CommonConstraints
import ru.yandex.direct.validation.constraint.NumberConstraints
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder
import java.math.BigDecimal

class AvgCpaWithPayForConversionValidator(private val container: ValidationContainer) : Validator<BigDecimal?, Defect<*>> {

    override fun apply(t: BigDecimal?): ValidationResult<BigDecimal?, Defect<*>> {
        return ModelItemValidationBuilder.of<BigDecimal, Defect<*>>(t)
            .checkBy(this::validateAvgCpaOrCpi)
            .result
    }

    private fun validateAvgCpaOrCpi(averageCpa: BigDecimal): ValidationResult<BigDecimal, Defect<*>> {
        val autobudgetPayForConversionAvgCpaWarning = CampaignWithStrategyValidationUtils.getAutobudgetPayForConversionAvgCpaWarning(
            container.availableFeatureNames,
            container.currency
        )
        return ModelItemValidationBuilder.of<BigDecimal, Defect<*>>(averageCpa)
            .check(CommonConstraints.notNull())
            .check(NumberConstraints.notGreaterThan(autobudgetPayForConversionAvgCpaWarning), When.isTrue(container.isPayForConversionEnabled))
            .check(NumberConstraints.notGreaterThan(container.currency.getAutobudgetAvgCpaWarning()), When.isFalse(container.isPayForConversionEnabled))
            .result
    }

    companion object {
        data class ValidationContainer(val isPayForConversionEnabled: Boolean,
                                       val availableFeatures: Set<FeatureName>,
                                       val currency: Currency) {
            val availableFeatureNames = availableFeatures.map(FeatureName::getName).toSet()
        }
    }
}
