package ru.yandex.direct.core.entity.strategy.type.withavgcpaandpayforconversion

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.strategy.container.StrategyAddOperationContainer
import ru.yandex.direct.core.entity.strategy.model.StrategyWithAvgCpaAndPayForConversion
import ru.yandex.direct.core.entity.strategy.validation.add.AbstractStrategyAddValidationTypeSupport
import ru.yandex.direct.validation.builder.ListValidationBuilder
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult

@Component
class StrategyWithAvgCpaAndPayForConversionAddValidationTypeSupport : AbstractStrategyAddValidationTypeSupport<StrategyWithAvgCpaAndPayForConversion>() {
    override fun getTypeClass(): Class<StrategyWithAvgCpaAndPayForConversion> = StrategyWithAvgCpaAndPayForConversion::class.java

    override fun validate(container: StrategyAddOperationContainer,
                          vr: ValidationResult<List<StrategyWithAvgCpaAndPayForConversion>, Defect<*>>): ValidationResult<List<StrategyWithAvgCpaAndPayForConversion>, Defect<*>> {
        val validator = StrategyWithAvgCpaAndPayForConversionValidatorProvider.createAddStrategyValidator(container)
        return ListValidationBuilder(vr)
            .checkEachBy(validator)
            .result
    }
}
