package ru.yandex.direct.core.entity.strategy.type.withavgcpaandpayforconversion

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.strategy.container.StrategyUpdateOperationContainer
import ru.yandex.direct.core.entity.strategy.model.StrategyWithAvgCpaAndPayForConversion
import ru.yandex.direct.core.entity.strategy.validation.update.AbstractStrategyUpdateValidationTypeSupport
import ru.yandex.direct.validation.builder.ListValidationBuilder
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult

@Component
class StrategyWithAvgCpaAndPayForConversionUpdateValidationTypeSupport : AbstractStrategyUpdateValidationTypeSupport<StrategyWithAvgCpaAndPayForConversion>() {
    override fun getTypeClass(): Class<StrategyWithAvgCpaAndPayForConversion> = StrategyWithAvgCpaAndPayForConversion::class.java

    override fun validate(container: StrategyUpdateOperationContainer,
                          vr: ValidationResult<List<StrategyWithAvgCpaAndPayForConversion>, Defect<*>>): ValidationResult<List<StrategyWithAvgCpaAndPayForConversion>, Defect<*>> {
        val validator = StrategyWithAvgCpaAndPayForConversionValidatorProvider.createUpdateStrategyValidator(container)
        return ListValidationBuilder(vr)
            .checkEachBy(validator)
            .result
    }
}
