package ru.yandex.direct.core.entity.strategy.type.withavgcpaandpayforconversion

import ru.yandex.direct.core.entity.strategy.container.AbstractStrategyOperationContainer
import ru.yandex.direct.core.entity.strategy.model.StrategyWithAvgCpaAndPayForConversion
import ru.yandex.direct.core.entity.strategy.validation.AbstractStrategyValidatorProvider
import ru.yandex.direct.utils.CommonUtils.nvl
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder

object StrategyWithAvgCpaAndPayForConversionValidatorProvider : AbstractStrategyValidatorProvider<StrategyWithAvgCpaAndPayForConversion>() {
    override fun createStrategyValidator(container: AbstractStrategyOperationContainer): Validator<StrategyWithAvgCpaAndPayForConversion, Defect<*>> =
        Validator { strategy: StrategyWithAvgCpaAndPayForConversion ->
            val validationContainer = AvgCpaWithPayForConversionValidator.Companion.ValidationContainer(
                nvl(strategy.isPayForConversionEnabled, false),
                container.availableFeatures,
                container.currency
            )

            val validator = AvgCpaWithPayForConversionValidator(validationContainer)

            val vb = ModelItemValidationBuilder.of(strategy)

            vb.item(StrategyWithAvgCpaAndPayForConversion.AVG_CPA)
                .checkBy(validator)

            vb.result
        }
}
