package ru.yandex.direct.core.entity.strategy.type.withavgcpaandweeklybudget

import ru.yandex.direct.core.entity.campaign.service.validation.StrategyDefects.weekBudgetLessThan
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.builder.When
import ru.yandex.direct.validation.constraint.CommonConstraints.notNull
import ru.yandex.direct.validation.constraint.NumberConstraints.notGreaterThan
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.validation.util.validateObject
import java.math.BigDecimal

class AvgCpaWithWeeklyBudgetValidator(private val container: ValidationContainer) : Validator<BigDecimal?, Defect<*>> {

    override fun apply(t: BigDecimal?): ValidationResult<BigDecimal?, Defect<*>> =
        validateObject(t) {
            check(notNull())
            check(notGreaterThan(container.sum), weekBudgetLessThan(), When.isTrue(container.sum != null))
        }

    companion object {
        data class ValidationContainer(val sum: BigDecimal?)
    }
}
