package ru.yandex.direct.core.entity.strategy.type.withavgcpaandweeklybudget

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.strategy.container.StrategyAddOperationContainer
import ru.yandex.direct.core.entity.strategy.model.StrategyWithAvgCpaAndWeeklyBudget
import ru.yandex.direct.core.entity.strategy.validation.add.AbstractStrategyAddValidationTypeSupport
import ru.yandex.direct.validation.builder.ListValidationBuilder
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult

@Component
class StrategyWithAvgCpaAndWeeklyBudgetAddValidationTypeSupport : AbstractStrategyAddValidationTypeSupport<StrategyWithAvgCpaAndWeeklyBudget>() {
    override fun getTypeClass(): Class<StrategyWithAvgCpaAndWeeklyBudget> = StrategyWithAvgCpaAndWeeklyBudget::class.java

    override fun validate(container: StrategyAddOperationContainer,
                          vr: ValidationResult<List<StrategyWithAvgCpaAndWeeklyBudget>, Defect<*>>): ValidationResult<List<StrategyWithAvgCpaAndWeeklyBudget>, Defect<*>> {
        val validator = StrategyWithAvgCpaAndWeeklyBudgetValidatorProvider.createAddStrategyValidator(container)

        return ListValidationBuilder(vr)
            .checkEachBy(validator)
            .result
    }
}
