package ru.yandex.direct.core.entity.strategy.type.withavgcpaandweeklybudget

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.strategy.container.StrategyUpdateOperationContainer
import ru.yandex.direct.core.entity.strategy.model.StrategyWithAvgCpaAndWeeklyBudget
import ru.yandex.direct.core.entity.strategy.validation.update.AbstractStrategyUpdateValidationTypeSupport
import ru.yandex.direct.validation.builder.ListValidationBuilder
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult

@Component
class StrategyWithAvgCpaAndWeeklyBudgetUpdateValidationTypeSupport : AbstractStrategyUpdateValidationTypeSupport<StrategyWithAvgCpaAndWeeklyBudget>() {
    override fun getTypeClass(): Class<StrategyWithAvgCpaAndWeeklyBudget> = StrategyWithAvgCpaAndWeeklyBudget::class.java


    override fun validate(container: StrategyUpdateOperationContainer,
                          vr: ValidationResult<List<StrategyWithAvgCpaAndWeeklyBudget>, Defect<*>>): ValidationResult<List<StrategyWithAvgCpaAndWeeklyBudget>, Defect<*>> {
        val validator = StrategyWithAvgCpaAndWeeklyBudgetValidatorProvider.createUpdateStrategyValidator(container)

        return ListValidationBuilder(vr)
            .checkEachBy(validator)
            .result
    }
}
