package ru.yandex.direct.core.entity.strategy.type.withavgcpaandweeklybudget

import ru.yandex.direct.core.entity.strategy.container.AbstractStrategyOperationContainer
import ru.yandex.direct.core.entity.strategy.model.StrategyWithAvgCpaAndWeeklyBudget
import ru.yandex.direct.core.entity.strategy.validation.AbstractStrategyValidatorProvider
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder

object StrategyWithAvgCpaAndWeeklyBudgetValidatorProvider : AbstractStrategyValidatorProvider<StrategyWithAvgCpaAndWeeklyBudget>() {
    
    override fun createStrategyValidator(container: AbstractStrategyOperationContainer): Validator<StrategyWithAvgCpaAndWeeklyBudget, Defect<*>> =
        Validator { strategy: StrategyWithAvgCpaAndWeeklyBudget ->
            val validationContainer = AvgCpaWithWeeklyBudgetValidator.Companion.ValidationContainer(
                strategy.sum
            )
            val validator = AvgCpaWithWeeklyBudgetValidator(validationContainer)
            val vb = ModelItemValidationBuilder.of(strategy)

            vb.item(StrategyWithAvgCpaAndWeeklyBudget.AVG_CPA)
                .checkBy(validator)

            vb.result
        }
}
