package ru.yandex.direct.core.entity.strategy.type.withavgcpm

import ru.yandex.direct.core.entity.adgroup.model.AdGroupType
import ru.yandex.direct.core.entity.bids.validation.PriceValidator
import ru.yandex.direct.core.entity.campaign.model.CampaignType
import ru.yandex.direct.core.entity.currency.model.cpmyndxfrontpage.CpmYndxFrontpageAdGroupPriceRestrictions
import ru.yandex.direct.currency.Currency
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.builder.When
import ru.yandex.direct.validation.constraint.CommonConstraints
import ru.yandex.direct.validation.constraint.NumberConstraints
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder
import java.math.BigDecimal

class AvgCpmValidator(
    private val currency: Currency,
    private val cpmYndxFrontpageAdGroupPriceRestrictions: CpmYndxFrontpageAdGroupPriceRestrictions?,
    private val campaignsType: CampaignType?,
    forceValidateAvgCpmMin: Boolean
) : Validator<BigDecimal, Defect<*>> {

    override fun apply(value: BigDecimal?): ValidationResult<BigDecimal, Defect<*>> =
        ModelItemValidationBuilder.of<BigDecimal, Defect<*>>(value)
            .check(CommonConstraints.notNull())
            .check(
                NumberConstraints.notLessThan(currency.minAutobudgetAvgCpm),
                When.isTrue(shouldValidateAvgCpmMinValueCondition)
            )
            .check(NumberConstraints.notGreaterThan(currency.maxCpmPrice))
            .checkBy(
                {
                    PriceValidator(
                        currency, AdGroupType.CPM_YNDX_FRONTPAGE,
                        cpmYndxFrontpageAdGroupPriceRestrictions
                    ).apply(it)
                },
                When.isTrue(
                    campaignsType == CampaignType.CPM_YNDX_FRONTPAGE
                        && cpmYndxFrontpageAdGroupPriceRestrictions != null
                )
            )
            .result

    private val shouldValidateAvgCpmMinValueCondition = campaignsType == CampaignType.CPM_PRICE
        || campaignsType == CampaignType.CPM_YNDX_FRONTPAGE
        || forceValidateAvgCpmMin
}
