package ru.yandex.direct.core.entity.strategy.type.withavgcpm

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy
import ru.yandex.direct.core.entity.strategy.model.StrategyWithAvgCpm
import ru.yandex.direct.core.entity.strategy.service.converter.CampaignToStrategyConverterSupport
import ru.yandex.direct.dbutil.model.ClientId
import java.time.LocalDateTime
import javax.annotation.ParametersAreNonnullByDefault

@Component
@ParametersAreNonnullByDefault
class CampaignToStrategyWithAvgCpmConverterSupport :
    CampaignToStrategyConverterSupport<StrategyWithAvgCpm> {
    override fun fillTypeSpecificFields(
        strategy: StrategyWithAvgCpm,
        clientId: ClientId,
        now: LocalDateTime,
        campaign: CampaignWithPackageStrategy
    ) {
        strategy.withAvgCpm(campaign.strategy.strategyData.avgCpm)
    }

    override fun getTypeClass() = StrategyWithAvgCpm::class.java
}
