package ru.yandex.direct.core.entity.strategy.type.withavgcpm

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.strategy.container.StrategyAddOperationContainer
import ru.yandex.direct.core.entity.strategy.model.StrategyWithAvgCpm
import ru.yandex.direct.core.entity.strategy.validation.add.AbstractStrategyAddValidationTypeSupport
import ru.yandex.direct.validation.builder.ListValidationBuilder
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult

@Component
class StrategyWithAvgCpmAddValidationTypeSupport :
    AbstractStrategyAddValidationTypeSupport<StrategyWithAvgCpm>() {

    override fun validate(
        container: StrategyAddOperationContainer,
        vr: ValidationResult<List<StrategyWithAvgCpm>, Defect<*>>
    ): ValidationResult<List<StrategyWithAvgCpm>, Defect<*>> {
        val validator = StrategyWithAvgCpmValidatorProvider.createAddStrategyValidator(container);

        return ListValidationBuilder(vr)
            .checkEachBy(validator)
            .result
    }

    override fun getTypeClass() = StrategyWithAvgCpm::class.java
}
