package ru.yandex.direct.core.entity.strategy.type.withavgcpm;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.TableField;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.strategy.model.StrategyWithAvgCpm;
import ru.yandex.direct.core.entity.strategy.repository.BaseStrategyDataFieldRepositoryTypeSupport;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapper;

import static ru.yandex.direct.dbschema.ppc.tables.Strategies.STRATEGIES;
import static ru.yandex.direct.jooqmapper.JsonReaderWriterBuilders.jsonBigDecimal;

@Component
@ParametersAreNonnullByDefault
public class StrategyWithAvgCpmRepositoryTypeSupport extends BaseStrategyDataFieldRepositoryTypeSupport<StrategyWithAvgCpm> {

    protected StrategyWithAvgCpmRepositoryTypeSupport(DslContextProvider dslContextProvider) {
        super(dslContextProvider);
    }

    @Override
    public JooqMapper<StrategyWithAvgCpm> createMapper() {
        return baseBuilder()
                .map(jsonBigDecimal(
                        StrategyWithAvgCpm.AVG_CPM,
                        STRATEGIES.STRATEGY_DATA,
                        "avg_cpm"
                )).build();
    }

    @Override
    public Set<TableField<?, Long>> getPrimaryKeys() {
        return Set.of(STRATEGIES.STRATEGY_ID);
    }

    @Override
    public Class<StrategyWithAvgCpm> getTypeClass() {
        return StrategyWithAvgCpm.class;
    }

}
