package ru.yandex.direct.core.entity.strategy.type.withavgcpm

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.model.CampaignWithPackageStrategy
import ru.yandex.direct.core.entity.campaign.model.StrategyData
import ru.yandex.direct.core.entity.strategy.model.StrategyWithAvgCpm
import ru.yandex.direct.core.entity.strategy.service.converter.StrategyToCampaignConverterSupport
import ru.yandex.direct.core.entity.strategy.service.converter.StrategyToCampaignConverterUtils
import ru.yandex.direct.model.ModelChanges
import java.time.LocalDateTime
import javax.annotation.ParametersAreNonnullByDefault

@Component
@ParametersAreNonnullByDefault
class StrategyWithAvgCpmToCampaignConverterSupport : StrategyToCampaignConverterSupport<StrategyWithAvgCpm> {
    override fun fillCampaignTypeSpecificFields(
        strategy: StrategyWithAvgCpm,
        now: LocalDateTime,
        campaign: CampaignWithPackageStrategy
    ) {
        fill(StrategyToCampaignConverterUtils.createStrategyDataIfNull(campaign), strategy)
    }

    override fun processCampaignModelChangesTypeSpecificProperties(
        strategy: StrategyWithAvgCpm,
        now: LocalDateTime,
        modelChanges: ModelChanges<CampaignWithPackageStrategy>,
        campaignClass: Class<out CampaignWithPackageStrategy>
    ) {
        fill(StrategyToCampaignConverterUtils.createStrategyDataIfNull(modelChanges), strategy)
    }

    override fun getTypeClass() = StrategyWithAvgCpm::class.java

    private fun fill(strategyData: StrategyData, strategy: StrategyWithAvgCpm) {
        strategyData.avgCpm = strategy.avgCpm
    }
}
