package ru.yandex.direct.core.entity.strategy.type.withavgcpm

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.strategy.container.StrategyUpdateOperationContainer
import ru.yandex.direct.core.entity.strategy.model.StrategyWithAvgCpm
import ru.yandex.direct.core.entity.strategy.validation.update.AbstractStrategyUpdateValidationTypeSupport
import ru.yandex.direct.validation.builder.ListValidationBuilder
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult

@Component
class StrategyWithAvgCpmUpdateValidationTypeSupport :
    AbstractStrategyUpdateValidationTypeSupport<StrategyWithAvgCpm>() {

    override fun validate(
        container: StrategyUpdateOperationContainer,
        vr: ValidationResult<MutableList<StrategyWithAvgCpm>, Defect<*>>
    ): ValidationResult<MutableList<StrategyWithAvgCpm>, Defect<*>> {
        val validator = StrategyWithAvgCpmValidatorProvider.createUpdateStrategyValidator(container)

        return ListValidationBuilder(vr)
            .checkEachBy(validator)
            .result
    }

    override fun getTypeClass() = StrategyWithAvgCpm::class.java

}
