package ru.yandex.direct.core.entity.strategy.type.withavgcpm

import ru.yandex.direct.core.entity.strategy.container.AbstractStrategyOperationContainer
import ru.yandex.direct.core.entity.strategy.model.StrategyWithAvgCpm
import ru.yandex.direct.core.entity.strategy.validation.AbstractStrategyValidatorProvider
import ru.yandex.direct.validation.builder.Validator
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder

object StrategyWithAvgCpmValidatorProvider : AbstractStrategyValidatorProvider<StrategyWithAvgCpm>() {
    override fun createStrategyValidator(container: AbstractStrategyOperationContainer) =
        Validator { strategy: StrategyWithAvgCpm ->
            val vb = ModelItemValidationBuilder.of(strategy)

            vb.item(StrategyWithAvgCpm.AVG_CPM)
                .checkBy(
                    AvgCpmValidator(
                        container.currency,
                        container.cpmYndxFrontpageAdGroupPriceRestrictions,
                        container.campaignType(strategy),
                        container.options.forceValidateAvgCpmMin
                    )
                )

            vb.result
        }
}
